<?php
include('connect.php');
session_start();

// احضر آخر تقرير مضاف
$stmt = $con->prepare("SELECT * FROM reports WHERE employee_name = ? ORDER BY id DESC LIMIT 1");
$stmt->bind_param("s", $_SESSION['username']);
$stmt->execute();
$result = $stmt->get_result();
$report = $result->fetch_assoc();
$stmt->close();

if (!$report) {
    echo "لا يوجد تقرير للطباعة.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>طباعة التقرير</title>
    <style>
        @page {
            size: 80mm auto; /* 80mm width, length auto to allow continuous printing */
            margin: 0;
        }
        body {
            font-family: Arial, sans-serif;
            width: 70mm;
            margin: 0 auto;
            text-align: right;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
            word-wrap: break-word;
        }
        th {
            background-color: #e8f0fe;
        }
        .summary {
            margin-top: 10px;
            font-weight: bold;
        }

        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <h3>تقرير المبيعات اليومية</h3>
    <table>
        <thead>
            <tr>
                <th>اسم</th>
                <th>التاريخ</th>
                <th>مبيعات</th>
                <th>مصاريف</th>
                <th>ملاحظات</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?= htmlspecialchars($report['employee_name']) ?></td>
                <td><?= date('H:i d-m-Y', strtotime($report['entry_time'])) ?></td>
                <td>₪<?= number_format($report['sales'], 2) ?></td>
                <td>₪<?= number_format($report['expenses'], 2) ?></td>
                <td><?= htmlspecialchars($report['notes']) ?></td>
            </tr>
        </tbody>
    </table>

    <div class="summary">
        الصافي: ₪<?= number_format($report['sales'] - $report['expenses'], 2) ?>
    </div>

    <div class="no-print" style="margin-top: 15px;">
        <button onclick="window.print()">طباعة</button>
        <a href="user_page.php">عودة</a>
    </div>

    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>
